package com.example.myapplication

import android.os.Build
import android.os.Bundle
import android.util.Log
import android.view.View
import android.view.animation.AlphaAnimation
import android.view.animation.Animation
import android.view.animation.AnimationUtils
import android.widget.*
import androidx.annotation.RequiresApi
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import kotlinx.android.synthetic.main.table.*
import kotlinx.android.synthetic.main.table.*
import kotlinx.android.synthetic.main.ticktacktoo.*
import kotlin.concurrent.thread


class MainActivity: AppCompatActivity(), View.OnClickListener, NumberPicker.OnValueChangeListener {
    lateinit var squares:Squares
    var next:Boolean = true
    var isFinal = true
    lateinit var imagebutton:Array<Array<ImageButton>>
    lateinit var row:Array<TableRow>
    var count = 0
    lateinit var anim1: Animation


    @RequiresApi(Build.VERSION_CODES.KITKAT)
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.ticktacktoo)

        imagebutton = arrayOf(
            arrayOf(imageButton11,imageButton12,imageButton13,imageButton14,imageButton15,imageButton16,imageButton17),
            arrayOf(imageButton21,imageButton22,imageButton23,imageButton24,imageButton25,imageButton26,imageButton27),
            arrayOf(imageButton31,imageButton32,imageButton33,imageButton34,imageButton35,imageButton36,imageButton37),
            arrayOf(imageButton41,imageButton42,imageButton43,imageButton44,imageButton45,imageButton46,imageButton47),
            arrayOf(imageButton51,imageButton52,imageButton53,imageButton54,imageButton55,imageButton56,imageButton57),
            arrayOf(imageButton61,imageButton62,imageButton63,imageButton64,imageButton65,imageButton66,imageButton67),
            arrayOf(imageButton71,imageButton72,imageButton73,imageButton74,imageButton75,imageButton76,imageButton77)
        )
        row = arrayOf(tablerow1,tablerow2,tablerow3,tablerow4,tablerow5,tablerow6,tablerow7)
        imagebutton.forEachIndexed { idx1, element ->
            element.forEachIndexed{idx2,element2->
                Log.d("MainActivity","f["+idx1+"]"+"["+idx2+"]=")
                imagebutton[idx1][idx2].setOnClickListener(this)
                var array = arrayOf(idx1,idx2)
                imagebutton[idx1][idx2].setTag(array)
            }
        }
        button.setOnClickListener(this)

        numberPicker.minValue = Const.BAN_MINI
        numberPicker.maxValue = Const.BAN_MAX
        numberPicker.value = Const.BAN_MINI
        numberPicker.setOnValueChangedListener(this)

        numberPicker2.minValue = Const.BAN_MINI
        numberPicker2.maxValue = Const.BAN_MAX
        numberPicker2.value = Const.BAN_MINI

        numberPicker2.setOnValueChangedListener(this)

        anim1 = AnimationUtils.loadAnimation(this, R.anim.anim1)

        squares = Squares(imagebutton)
        init()
    }
    override fun onClick(p0: View?) {
        when (p0!!.id) {
            R.id.button -> buttonClick()
            else -> imagebuttonClick(p0)
        }
    }

    fun imagebuttonClick(p0: View?){
        if(isFinal || !next){                                //試合終了なら処理しない
            return
        }
        var button = p0 as ImageButton
        var array  = button.getTag() as Array<Int>
        textView3.text = ""
        if(!squares.isKUHAKU(array[0],array[1])) {
            textView3.text = getString(R.string.MSG_ALREADY)
            return
        }
        squares.click(array[0], array[1], next)
        imagebutton[array[0]][array[1]].startAnimation(anim1)
        var win = squares.jug(array[0],array[1],numberPicker2.value,numberPicker.value)
        if(checkCount()){
            final(Const.DRAW);
        }else if(win != Const.KUHAKU){
            final(win)
        }else {
            next = !next
            if (!next) {
                textView3.text = getString(R.string.MSG_WAIT)
                my()
            }
        }
    }
    fun my(){
        thread {    //別スレッド発生
            var ret = squares.stg(next, 1.0, numberPicker2.value, numberPicker.value)//思考ロジック
            if (ret != null) {
                this.runOnUiThread {    //UI更新
                squares.click(ret.y, ret.x, next)
                imagebutton[ret.y][ret.x].startAnimation(anim1)
                var win = squares.jug(ret!!.y, ret!!.x, numberPicker2.value, numberPicker.value)
                    textView3.text = getString(R.string.MSG_PROMPT)
                    if (win != Const.KUHAKU) {
                        final(win)
                    }
                    if (checkCount()) {
                        final(Const.DRAW);
                    }
                    next = !next
                }
            }
        }
    }
    private fun startScaling(imagegbutton:ImageButton) {
        runOnUiThread {
            val aa = AlphaAnimation(0.0f, 1.0f)
            aa.duration = 800
            imagegbutton.startAnimation(aa)
        }
    }
    fun checkCount():Boolean{
        ++count
        if( count >= numberPicker2.value * numberPicker2.value){
            return true
        }
        return false
    }
    fun init(){
        textView3.text = ""
        squares.allClear()
        next = true;
        buttonSet()
        count = 0
    }

    fun buttonClick(){
        if(isFinal){    //START
            init()
            textView3.text=getString(R.string.MSG_PROMPT)
            isFinal = false
            setBan()
            buttonSet()
        }else{          //RESET
            createDialog()
        }
    }

    fun final(win:Int){
        textView3.text = resources.getStringArray(R.array.MSG_FINAL)[win]
        isFinal = true
        buttonSet()
    }

    fun buttonSet(){
        if(isFinal){
            button.text = getString(R.string.LABEL_START)
            button.setBackgroundResource(R.drawable.button_blue)
        }else{
            button.text = getString(R.string.LABEL_RESET)
            button.setBackgroundResource(R.drawable.button_red)

        }
    }

    fun createDialog(){
        AlertDialog.Builder(this)
            .setTitle("RESET?")
            .setMessage(getString(R.string.MSG_RESET_CONFIRT))
            .setPositiveButton(getString(R.string.LABEL_OK)) { dialog, which -> //OK選択時処理
                init()
                isFinal = true
                buttonSet()
            }
            .setNegativeButton(getString(R.string.LABEL_NO), { dialog, which ->//NO選択時処理（何もしない）
            })
            .show()
    }

    fun setBan(){
        for(idx1 in imagebutton.indices) {
            if(idx1 < numberPicker2.value){
                row[idx1].setVisibility(View.VISIBLE);
            }else{
                row[idx1].setVisibility(View.GONE);
            }

            for (idx2 in imagebutton[idx1].indices) {
                if(idx2 < numberPicker2.value){
                    imagebutton[idx1][idx2].setVisibility(View.VISIBLE);
                }else{
                    imagebutton[idx1][idx2].setVisibility(View.GONE);
                }
            }
        }
    }

    override fun onValueChange(p0: NumberPicker?, p1: Int, p2: Int) {
        if(p0!!.id == R.id.numberPicker){
            numberPicker2.minValue =  numberPicker.value
            numberPicker2.value =  numberPicker.value
        }
    }
}



